//
//  AccountViewController.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 29.05.22.
//

import UIKit
import JNGradientLabel  // .package(url: "https://github.com/SomeRandomiOSDev/JNGradientLabel.git", from: "1.0.0")


class HomeAccountsViewController: UIViewController, UIViewControllerTransitioningDelegate {
    
    
    @IBOutlet weak var topBarLabel: JNGradientLabel!
    
    @IBOutlet var fromBankAccountLabel: UILabel!
    
    // account information
    @IBOutlet weak var accountLabel: UILabel!
    
    @IBOutlet var breakLinesAccountGiroLabel: UILabel!
    
    @IBOutlet var accountGiroDetails: UILabel!
    
    @IBOutlet weak var accountInvestingLabel: UILabel!
    
    @IBOutlet var breakLinesSavingsAndInvestingLabel: UILabel!
    @IBOutlet weak var accountInvestingDetails: UILabel!
    @IBOutlet var accountDaillyAllowanceDetailsLabel: UILabel!
    
    
    @IBOutlet var breakLinesBetweenSavingsAndInvestingLabel: UILabel!
    
    
    @IBOutlet var bankBalanceLabel: UILabel!
    @IBOutlet weak var accountDepotAmount: UILabel!
    @IBOutlet weak var accountGiroAmount: UILabel!
    @IBOutlet weak var accountDailyAllowanceAmountLabel: UILabel!
    
    /*
    // animate transition to main view...
    override func viewWillAppear(_ animated: Bool) {
        
        super.viewWillAppear(animated)

        UIView.animate(withDuration: 0.25) {
            self.view.alpha = 1
        }
    }

    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)

        UIView.animate(withDuration: 0.25) {
            self.view.alpha = 0
        }
    }
     */
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // start Timer after successful login
        TimerManager.shared.startTimer_AfterLogin()
        
        
        UINavigationBar.appearance().titleTextAttributes = [.foregroundColor : UIColor.white,
                                                            .font : Fonts.mediumFontWithSize(size: 18)]
        self.navigationController?.navigationBar.titleTextAttributes = [NSAttributedString.Key.foregroundColor: UIColor.white]
        
        // gradient color for top bar
        topBarLabel.textColor = .white
        topBarLabel.textGradientLocation = .background
        topBarLabel.setAxialGradientParameters(startPoint: CGPoint(x: 0.0, y: 0.0),
                                                                endPoint: CGPoint(x: 1.0, y: 1.0),
                                                                colors: gradientColorsPublic,
                                                                locations: gradientlocationsPublic)
        
        // style top total bank balance label and number
        fromBankAccountLabel.font = Fonts.heavyFontWithSize(size: 20)
        
        bankBalanceLabel.font = Fonts.heavyFontWithSize(size: 20)
        
        // https://stackoverflow.com/questions/24803178/navigation-bar-with-uiimage-for-title
        //Sets the navigation title with text and image
            //self.navigationItem.titleView = navTitleWithImageAndText(titleText: "Meine Konten", imageName: "Logo_LT_FullName")
        
        
        // calculate sum bank balance (based on whether user transaction took place or not
        let defaults = UserDefaults.standard
        var sumBankBalance : Float = 0.00
        // User Transaction did not took place
        if defaults.object(forKey: "amountGiroAccount") != nil {
            let amountGiroAccountAfterTransaction = defaults.float(forKey: "amountGiroAccount")
            sumBankBalance = round(Float(amountGiroAccountAfterTransaction+amountDailyAllowancePublic + amountInvestingPublic) * 100) / 100.0
            
        } else { // User transaction done
            sumBankBalance = round(Float(amountGiroAccountPublic + amountDailyAllowancePublic + amountInvestingPublic) * 100) / 100.0
            
        }
        
        var bankBalanceString = String(sumBankBalance).replacingOccurrences(of: ".", with: ",")
        
        if !Utilities.numberFollowedByDotAndExactTwoDigits(bankBalanceString) {
            bankBalanceString = bankBalanceString + "0"
        }
        bankBalanceString = bankBalanceString + " €"
        
        // add dots where needed, e.g., not needed for 100,99 €, 5,95 € but needed for 1.200,85 €
        Utilities.addDotsToBankBalance(sumFloat: Float(sumBankBalance) ,sumString: &bankBalanceString)
        
        bankBalanceLabel.text = bankBalanceString
        
        accountLabel.font = Fonts.heavyFontWithSize(size: 18)
        
        if hideAccountGiroPublic {
            accountLabel.isHidden = true
            breakLinesAccountGiroLabel.isHidden = true
            accountGiroDetails.isHidden = true
            accountGiroAmount.isHidden = true
        }
        if hideAccountSavingsPublic {
            accountInvestingDetails.isHidden = true
            accountDepotAmount.isHidden = true
            breakLinesBetweenSavingsAndInvestingLabel.isHidden = true
            

        }
        if hideAccountInvestmentPublic {
            accountDaillyAllowanceDetailsLabel.isHidden = true
            accountDailyAllowanceAmountLabel.isHidden = true
            breakLinesBetweenSavingsAndInvestingLabel.isHidden = true
            
            // corner anpassen...
            accountInvestingDetails.layer.cornerRadius = 10
            accountInvestingDetails.layer.masksToBounds = true
            accountInvestingDetails.layer.maskedCorners = [.layerMinXMaxYCorner]
            
            accountDepotAmount.layer.cornerRadius = 10
            accountDepotAmount.layer.masksToBounds = true
            accountDepotAmount.layer.maskedCorners = [.layerMaxXMaxYCorner]
        }
        if (hideAccountSavingsPublic && hideAccountInvestmentPublic) {
            accountInvestingLabel.isHidden = true
            breakLinesSavingsAndInvestingLabel.isHidden = true
            breakLinesBetweenSavingsAndInvestingLabel.isHidden = true
        }
        
        
        
        accountLabel.layer.cornerRadius = 10
        accountLabel.layer.masksToBounds = true
        accountLabel.layer.maskedCorners = [.layerMinXMinYCorner, .layerMaxXMinYCorner]
        // Create Attachment
        let imageAttachment = NSTextAttachment()
        imageAttachment.image = UIImage(named:"IconGreenBulbEuro_small")
        // Set bound to reposition
        let imageOffsetY: CGFloat = -5.0
        imageAttachment.bounds = CGRect(x: 0, y: imageOffsetY, width: imageAttachment.image!.size.width, height: imageAttachment.image!.size.height)
        // Create string with attachment
        let attachmentString = NSAttributedString(attachment: imageAttachment)
        // Initialize mutable string
        let completeText = NSMutableAttributedString(string: "")
        // Add image to mutable string
        completeText.append(attachmentString)
        // Add your text to mutable string
        let textAfterIcon = NSAttributedString(string: " Accounts") // Girokonto
        completeText.append(textAfterIcon)
        self.accountLabel.textAlignment = .left
        self.accountLabel.attributedText = completeText
        

        
        accountGiroDetails.layer.cornerRadius = 10
        accountGiroDetails.layer.masksToBounds = true
        accountGiroDetails.layer.maskedCorners = [.layerMinXMaxYCorner]
        
        accountGiroDetails.numberOfLines = 0
        accountGiroDetails.lineBreakMode = .byTruncatingTail
        let detailsGiro = NSMutableAttributedString.init(string: "   LightBanking Giro Premium\n   DE12 2707 0369 1128 5096 19")
        
        accountGiroDetails.font = Fonts.mediumFontWithSize(size: 16)
        detailsGiro.setAttributes([NSAttributedString.Key.font: Fonts.mediumFontWithSize(size: 16),
                                    NSAttributedString.Key.foregroundColor: UIColor.darkGray],
                                   range: NSMakeRange(0, 28)) // 25
        
        accountGiroDetails.attributedText = detailsGiro
        
        // Enable User Interaction
        accountGiroDetails.isUserInteractionEnabled = true
        // Create and add the Gesture Recognizer
        let guestureRecognizerAccountGiroDetails = UITapGestureRecognizer(target: self, action: #selector(labelClicked(_:)))
        accountGiroDetails.addGestureRecognizer(guestureRecognizerAccountGiroDetails)

        
        let amountColor = UIColor(red: 65.0/255.0, green: 109.0/255.0, blue: 186.0/255.0, alpha: 1.0)
        
        /*### accountGiroAmount ###*/
        let guestureRecognizerAccountGiroAmount = UITapGestureRecognizer(target: self, action: #selector(labelClicked(_:)))
        accountGiroAmount.isUserInteractionEnabled = true
        accountGiroAmount.addGestureRecognizer(guestureRecognizerAccountGiroAmount)
        accountGiroAmount.layer.cornerRadius = 10
        accountGiroAmount.layer.masksToBounds = true
        accountGiroAmount.layer.maskedCorners = [.layerMaxXMaxYCorner]
        
        accountGiroAmount.textAlignment = .right
        
        
        // calculate giro account amount (based on whether user transaction took place or not
        // User Transaction did not took place
        var amountGiroAccountString : String = ""
        var sumGiroAccount : Float = 0.00
        if defaults.object(forKey: "amountGiroAccount") != nil {
            let amountGiroAccountAfterTransaction = defaults.float(forKey: "amountGiroAccount")
            //sumGiroAccount = amountGiroAccountPublic-userTransactionAmountDouble
            sumGiroAccount = round(amountGiroAccountAfterTransaction * 100) / 100.0
            print("amountGiroAccountPublic:")
            print(amountGiroAccountPublic)
            print("userTransactionAmountDouble:")
            print(amountGiroAccountAfterTransaction)
            
        } else { // User transaction done
            sumGiroAccount = amountGiroAccountPublic
        }
        
        amountGiroAccountString = String(format: "%.2f", sumGiroAccount).replacingOccurrences(of: ".", with: ",") + " €"
        
        Utilities.addDotsToBankBalance(sumFloat: sumGiroAccount ,sumString: &amountGiroAccountString)

        let accountGiroAmountStringAttributes = NSMutableAttributedString.init(string: amountGiroAccountString + "--")
        
        accountGiroAmountStringAttributes.setAttributes([NSAttributedString.Key.font: UIFont.systemFont(ofSize: 17, weight: .semibold),
                                    NSAttributedString.Key.foregroundColor: amountColor],
                                              range: NSMakeRange(0, amountGiroAccountString.count))
        
        accountGiroAmount.attributedText = accountGiroAmountStringAttributes
        
        accountGiroAmount.font = Fonts.mediumFontWithSize(size: 17)
        
        accountInvestingLabel.layer.cornerRadius = 10
        accountInvestingLabel.layer.masksToBounds = true
        accountInvestingLabel.layer.maskedCorners = [.layerMinXMinYCorner, .layerMaxXMinYCorner]
        
        accountInvestingLabel.font = Fonts.heavyFontWithSize(size: 18)
        
        // Create Attachment
        let imageAttachment2 = NSTextAttachment()
        imageAttachment2.image = UIImage(named:"IconGreenBulbChart_small")
        // Set bound to reposition
        let imageOffsetY2: CGFloat = -5.0
        imageAttachment2.bounds = CGRect(x: 0, y: imageOffsetY2, width: imageAttachment2.image!.size.width, height: imageAttachment2.image!.size.height)
        // Create string with attachment
        let attachmentString2 = NSAttributedString(attachment: imageAttachment2)
        // Initialize mutable string
        let completeText2 = NSMutableAttributedString(string: "")
        // Add image to mutable string
        completeText2.append(attachmentString2)
        // Add your text to mutable string
        let textAfterIcon2 = NSAttributedString(string: " Savings and Investments") // Sparen und Investieren
        completeText2.append(textAfterIcon2)
        self.accountInvestingLabel.textAlignment = .left
        self.accountInvestingLabel.attributedText = completeText2
        
        
        
        accountInvestingDetails.numberOfLines = 0
        accountInvestingDetails.lineBreakMode = .byTruncatingTail
        
        accountInvestingDetails.font = Fonts.mediumFontWithSize(size: 16)
        let detailsInvesting = NSMutableAttributedString.init(string: "   LightBanking Savings\n   DE48 2707 0369 6718 3181 74")
        
        
        detailsInvesting.setAttributes([NSAttributedString.Key.font: Fonts.mediumFontWithSize(size: 16),
                                    NSAttributedString.Key.foregroundColor: UIColor.darkGray],
                                   range: NSMakeRange(0, 25))
        
        accountInvestingDetails.attributedText = detailsInvesting
        
        
        /*### accountDailyAllowanceAmount ###*/
        accountDepotAmount.textAlignment = .right
        
        var amountDailyAllowanceAccountString = String(amountDailyAllowancePublic).replacingOccurrences(of: ".", with: ",") + " €"
        
        Utilities.addDotsToBankBalance(sumFloat: amountDailyAllowancePublic ,sumString: &amountDailyAllowanceAccountString)
    
        
        let accountDailyAllowanceAmountStringAttributes = NSMutableAttributedString.init(string: amountDailyAllowanceAccountString + "--")
        
        accountDailyAllowanceAmountStringAttributes.setAttributes([NSAttributedString.Key.font: UIFont.systemFont(ofSize: 17, weight: .semibold),
                                    NSAttributedString.Key.foregroundColor: amountColor],
                                              range: NSMakeRange(0, amountDailyAllowanceAccountString.count))
        
        accountDepotAmount.attributedText = accountDailyAllowanceAmountStringAttributes
        
        accountDepotAmount.font = Fonts.mediumFontWithSize(size: 17)
        
        
        accountDaillyAllowanceDetailsLabel.layer.cornerRadius = 10
        accountDaillyAllowanceDetailsLabel.layer.masksToBounds = true
        accountDaillyAllowanceDetailsLabel.layer.maskedCorners = [.layerMinXMaxYCorner]
        
        accountDaillyAllowanceDetailsLabel.numberOfLines = 0
        accountDaillyAllowanceDetailsLabel.lineBreakMode = .byTruncatingTail
        
        accountDaillyAllowanceDetailsLabel.font = Fonts.mediumFontWithSize(size: 16)
        let detailsDailyAllowance = NSMutableAttributedString.init(string: "   LightBanking Depot\n   305861073900")
        
        detailsDailyAllowance.setAttributes([NSAttributedString.Key.font: UIFont.systemFont(ofSize: 16),
                                    NSAttributedString.Key.foregroundColor: UIColor.darkGray],
                                   range: NSMakeRange(0, 25))
        
        accountDaillyAllowanceDetailsLabel.attributedText = detailsDailyAllowance
        
        
        /*### accountDailyAllowanceAmount ###*/
        accountDailyAllowanceAmountLabel.layer.cornerRadius = 10
        accountDailyAllowanceAmountLabel.layer.masksToBounds = true
        accountDailyAllowanceAmountLabel.layer.maskedCorners = [.layerMaxXMaxYCorner]
        
        accountDailyAllowanceAmountLabel.textAlignment = .right
        
        var amountInvestingsAccountString = String(amountInvestingPublic).replacingOccurrences(of: ".", with: ",") + " €"
        
        Utilities.addDotsToBankBalance(sumFloat: amountInvestingPublic ,sumString: &amountInvestingsAccountString)

        let accountInvestingAmountStringAttributes = NSMutableAttributedString.init(string: amountInvestingsAccountString + "--")
        
        accountInvestingAmountStringAttributes.setAttributes([NSAttributedString.Key.font: UIFont.systemFont(ofSize: 17, weight: .semibold),
                                    NSAttributedString.Key.foregroundColor: amountColor],
                                              range: NSMakeRange(0, amountInvestingsAccountString.count))
        
        accountDailyAllowanceAmountLabel.attributedText = accountInvestingAmountStringAttributes
        
        accountDailyAllowanceAmountLabel.font = Fonts.mediumFontWithSize(size: 17)
        
        
        
        NotificationCenter.default.addObserver(self, selector: #selector(hideAccountGiro(notification:)), name: Notification.Name("hideAccountGiro"), object: nil)

        if lockAppPIN_SurveyIncompletePublic == true && (appPINPublic != developerAppPINPublic) {
            DispatchQueue.main.async { [weak self] in
                let storyboard = UIStoryboard(name: "Main", bundle: nil)
                        let nc = storyboard.instantiateViewController(withIdentifier: "QualtricsNotificationAuthenticationScreenNC")
                nc.modalPresentationStyle = .custom
                nc.transitioningDelegate = self
                self?.present(nc, animated: true, completion: nil)
                
                
                
                print("Dismiss Authentication Screen")
            }
        }
    }
    
    
    @IBAction func logOutButton(_ sender: Any) {
        let refreshAlert = UIAlertController(title: nil, message: nil, preferredStyle: UIAlertController.Style.alert)
            
        let paragraphStyle = NSMutableParagraphStyle()
        paragraphStyle.alignment = .left
        
        let message = "Sind Sie sicher, dass Sie sich ausloggen wollen?"
        let attributedMessage = NSAttributedString(string: message, attributes: [NSAttributedString.Key.paragraphStyle: paragraphStyle])
        
        refreshAlert.setValue(attributedMessage, forKey: "attributedMessage")

        refreshAlert.addAction(UIAlertAction(title: "Eingeloggt bleiben", style: .cancel, handler: { (action: UIAlertAction!) in

            
        }))
        if let continueAction = refreshAlert.actions.first(where: { $0.title == "Eingeloggt bleiben" }) {
            continueAction.setValue(UIColor(red: 49.0/255.0, green: 84.0/255.0, blue: 143.0/255.0, alpha: 1.0), forKey: "titleTextColor")
        }
         
        refreshAlert.addAction(UIAlertAction(title: "Ausloggen", style: .default, handler: { (action: UIAlertAction!) in
            
            let vc = self.storyboard?.instantiateViewController(withIdentifier: "TEST55")
            
            let layout = UICollectionViewFlowLayout()
            self.view.window?.rootViewController = AuthenticationScreenViewController(collectionViewLayout: layout)
            
            
            
            self.view.window?.rootViewController = vc
            self.view.window?.makeKeyAndVisible()
        }))
        
        if let cancelAction = refreshAlert.actions.first(where: { $0.title == "Ausloggen" }) {
            cancelAction.setValue(Colors.greyColor, forKey: "titleTextColor")
        }
         
        present(refreshAlert, animated: true, completion: nil)
    }
    
    
    
    @objc func labelClicked(_ sender: Any) {
        
        let navigationBarController = self.storyboard?.instantiateViewController(withIdentifier: "accountDetailsNC") as! UINavigationController
        
        navigationBarController.modalPresentationStyle = .fullScreen
        navigationBarController.modalTransitionStyle = .flipHorizontal
        
        present(navigationBarController, animated: true)

    }
    
    @objc func hideAccountGiro(notification: NSNotification) {
        print("Received Notification Giro")

    }
    
}


